package ru.yandex.passport.familypay.backend;

public enum LimitMode {
    DAY {
        @Override
        public long limitValue(final LimitsInfo limitsInfo) {
            return limitsInfo.day();
        }

        @Override
        public LimitsInfo createLimitsInfo(final long value) {
            return new LimitsInfo(
                value,
                Long.MAX_VALUE,
                Long.MAX_VALUE,
                Long.MAX_VALUE);
        }
    },
    WEEK {
        @Override
        public long limitValue(final LimitsInfo limitsInfo) {
            return limitsInfo.week();
        }

        @Override
        public LimitsInfo createLimitsInfo(final long value) {
            return new LimitsInfo(
                Long.MAX_VALUE,
                value,
                Long.MAX_VALUE,
                Long.MAX_VALUE);
        }
    },
    MONTH {
        @Override
        public long limitValue(final LimitsInfo limitsInfo) {
            return limitsInfo.month();
        }

        @Override
        public LimitsInfo createLimitsInfo(final long value) {
            return new LimitsInfo(
                Long.MAX_VALUE,
                Long.MAX_VALUE,
                value,
                Long.MAX_VALUE);
        }
    },
    TOTAL {
        @Override
        public long limitValue(final LimitsInfo limitsInfo) {
            return limitsInfo.total();
        }

        @Override
        public LimitsInfo createLimitsInfo(final long value) {
            return new LimitsInfo(
                Long.MAX_VALUE,
                Long.MAX_VALUE,
                Long.MAX_VALUE,
                value);
        }
    };

    public abstract long limitValue(LimitsInfo limitsInfo);

    public abstract LimitsInfo createLimitsInfo(long limit);

    public static LimitMode detectLimitMode(final LimitsInfo limitsInfo) {
        if (limitsInfo.day() != Long.MAX_VALUE) {
            return LimitMode.DAY;
        } else if (limitsInfo.week() != Long.MAX_VALUE) {
            return LimitMode.WEEK;
        } else if (limitsInfo.month() != Long.MAX_VALUE) {
            return LimitMode.MONTH;
        } else {
            return LimitMode.TOTAL;
        }
    }
}

