package ru.yandex.passport.familypay.backend;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import org.apache.http.HttpException;

import ru.yandex.client.pg.SqlQuery;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;

public class PaymentHandler extends PaymentHandlerBase {
    private static final SqlQuery FIND_PAYMENT =
        new SqlQuery("find-payment.sql", PaymentHandler.class);

    public PaymentHandler(final FamilypayBackend server) {
        super(server, true);
    }

    @Override
    protected void handle(
        final String paymentId,
        final RequestContext context)
        throws HttpException
    {
        server.pgClient().executeOnMaster(
            FIND_PAYMENT,
            Tuple.of(paymentId),
            context.session().listener(),
            new Callback(context));
    }

    private static class Callback
        extends AbstractFamilypayCallback<RowSet<Row>>
    {
        Callback(final RequestContext context) {
            super(context);
        }

        @Override
        public void completed(final RowSet<Row> rowSet) {
            try {
                if (rowSet.rowCount() <= 0) {
                    failed(ErrorType.PAYMENT_NOT_FOUND, null, null);
                } else {
                    Row row = rowSet.iterator().next();
                    JsonMap result =
                        new JsonMap(BasicContainerFactory.INSTANCE, 6);
                    result.put(
                        "paymentId",
                        new JsonString(row.getString("id")));
                    result.put(
                        "payer",
                        new JsonLong(row.getLong("initiator_uid")));
                    result.put(
                        "cardId",
                        new JsonString(row.getString("card_id")));
                    result.put("amount", new JsonLong(row.getLong("amount")));
                    sendResponse(result);
                }
            } catch (RuntimeException e) {
                failed(
                    ErrorType.INTERNAL_ERROR,
                    "Failed to parse database response",
                    e);
            }
        }
    }
}

