package ru.yandex.passport.familypay.backend;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.parser.string.NonEmptyValidator;

public abstract class PaymentHandlerBase
    implements HttpAsyncRequestHandler<HttpRequest>
{
    protected final FamilypayBackend server;
    private final boolean quiet;

    protected PaymentHandlerBase(
        final FamilypayBackend server,
        final boolean quiet)
    {
        this.server = server;
        this.quiet = quiet;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        RequestContext requestContext =
            new RequestContext(
                server,
                session,
                server.tskvLogger().record()
                    .append(TskvFields.HANDLER, getClass().getSimpleName()),
                "",
                quiet);
        try {
            handle(
                session.params().get("paymentId", NonEmptyValidator.INSTANCE),
                requestContext);
        } catch (HttpException e) {
            AbstractFamilypayCallback.failed(
                requestContext,
                ErrorType.MALFORMED_URI,
                null,
                e);
        }
    }

    protected abstract void handle(
        String paymentId,
        RequestContext context)
        throws HttpException;
}

