package ru.yandex.passport.familypay.backend;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;

import ru.yandex.client.pg.SqlQuery;
import ru.yandex.http.util.server.HttpServer;

public class ResetUserExpensesHandler extends UserHandlerBase {
    private static final SqlQuery RESET_EXPENSES =
        new SqlQuery("reset-expenses.sql", ResetUserExpensesHandler.class);

    public ResetUserExpensesHandler(final FamilypayBackend server) {
        super(server, false);
    }

    @Override
    protected void handle(final long uid, final RequestContext context) {
        Long adminUid =
            (Long) context.session().context().getAttribute(
                HttpServer.TVM_USER_UID);

        Tuple tuple = Tuple.tuple();
        tuple.addLong(uid);
        tuple.addLong(adminUid);
        FamilyCallback callback = new FamilyCallback(context, tuple);
        FamilyHandler.findFamilyByAdminUid(adminUid, callback);
    }

    private static class FamilyCallback
        extends AbstractFamilypayCallback<Family>
    {
        private final Tuple tuple;

        FamilyCallback(
            final RequestContext context,
            final Tuple tuple)
        {
            super(context);
            this.tuple = tuple;
        }

        @Override
        public void completed(final Family family) {
            context.server().pgClient().executeOnMaster(
                RESET_EXPENSES,
                tuple,
                context.session().listener(),
                new Callback(context, family));
        }
    }

    private static class Callback
        extends AbstractFamilypayCallback<RowSet<Row>>
    {
        private final Family oldFamily;

        Callback(final RequestContext context, final Family oldFamily) {
            super(context);
            this.oldFamily = oldFamily;
        }

        @Override
        public void completed(final RowSet<Row> rowSet) {
            emptyResponse();

            FamilyHandler.findFamily(
                oldFamily.familyInfo().familyId(),
                new FamilyChangeNotifyCallback(context, oldFamily));
        }
    }
}

