package ru.yandex.passport.familypay.backend;

import org.apache.http.HttpException;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class SingleLimitFamilyStartHandler extends FamilyStartHandler {
    public SingleLimitFamilyStartHandler(final FamilypayBackend server) {
        super(server);
    }

    @Override
    protected void handle(
        final String familyId,
        final JsonObject payload,
        final RequestContext context)
        throws HttpException, JsonException
    {
        handle(
            familyId,
            payload,
            context,
            true);
    }

    @Override
    protected LimitsInfo parseLimits(final JsonObject payload)
        throws JsonException
    {
        return LimitsInfo.fromJsonSingle(payload.get("limit").asMap());
    }
}

