package ru.yandex.passport.familypay.backend;

import org.apache.http.HttpException;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class SingleLimitFamilyUpdateHandler extends FamilyUpdateHandler {
    public SingleLimitFamilyUpdateHandler(final FamilypayBackend server) {
        super(server);
    }

    @Override
    protected void handle(
        final String familyId,
        final JsonObject payload,
        final RequestContext context)
        throws HttpException, JsonException
    {
        JsonMap limitMap = payload.get("defaultLimit").asMapOrNull();
        LimitsInfo limitsInfo;
        if (limitMap == null) {
            limitsInfo = null;
        } else {
            limitsInfo = LimitsInfo.fromJsonSingle(limitMap);
        }
        handle(
            familyId,
            payload,
            context,
            limitsInfo);
    }
}

