package ru.yandex.passport.familypay.backend;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;

public class SingleLimitFamilyUpdateUsersHandler
    extends FamilyUpdateUsersHandler
{
    public SingleLimitFamilyUpdateUsersHandler(final FamilypayBackend server) {
        super(server);
    }

    @Override
    protected LimitsInfo parseLimits(final JsonMap userInfo)
        throws JsonException
    {
        JsonMap limitsMap = userInfo.get("limit").asMapOrNull();
        if (limitsMap == null) {
            return null;
        } else {
            return LimitsInfo.fromJsonSingle(limitsMap);
        }
    }
}

