package ru.yandex.passport.familypay.backend;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.FakeAsyncConsumer;

public abstract class UserHandlerBase
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private static final Pattern USER_ID =
        Pattern.compile("/user/([0-9]+).*");

    protected final FamilypayBackend server;
    private final boolean quiet;

    protected UserHandlerBase(
        final FamilypayBackend server,
        final boolean quiet)
    {
        this.server = server;
        this.quiet = quiet;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        String uri = session.request().getRequestLine().getUri();
        long uid;
        Matcher matcher = USER_ID.matcher(uri);
        if (matcher.matches()) {
            try {
                uid = Long.parseLong(matcher.group(1));
            } catch (RuntimeException e) {
                throw new BadRequestException(
                    "Failed to parse uid from uri <" + uri + '>',
                    e);
            }
        } else {
            throw new BadRequestException("Malformed uri <" + uri + '>');
        }
        RequestContext requestContext =
            new RequestContext(
                server,
                session,
                server.tskvLogger().record()
                    .append(TskvFields.HANDLER, getClass().getSimpleName())
                    .append(TskvFields.UNDERGOER_UID, uid),
                "",
                quiet);
        handle(uid, requestContext);
    }

    protected abstract void handle(long uid, RequestContext context)
        throws BadRequestException;
}

