package ru.yandex.passport.familypay.backend;

import io.vertx.sqlclient.Row;

import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonBoolean;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;

public class UserInfo {
    private final String familyId;
    private final long familyAdminUid;
    private final String familyOrigin;
    private final CardInfo cardInfo;
    private final FamilyMember memberInfo;

    public UserInfo(
        final String familyId,
        final long familyAdminUid,
        final String familyOrigin,
        final CardInfo cardInfo,
        final FamilyMember memberInfo)
    {
        this.familyId = familyId;
        this.familyAdminUid = familyAdminUid;
        this.familyOrigin = familyOrigin;
        this.cardInfo = cardInfo;
        this.memberInfo = memberInfo;
    }

    public static UserInfo fromRow(
        final Row row,
        final long uid,
        final boolean parseExpenses)
    {
        String origin;
        if (parseExpenses) {
            origin = row.getString("origin");
        } else {
            origin = null;
        }
        return new UserInfo(
            row.getString("family_id"),
            row.getLong("admin_uid"),
            origin,
            CardInfo.fromRow(row),
            FamilyMember.fromRow(row, uid, parseExpenses));
    }

    public JsonMap toJson(
        final ContainerFactory containerFactory,
        final boolean singleLimit)
    {
        JsonMap result = memberInfo.toJson(containerFactory, singleLimit);
        result.put("familyId", new JsonString(familyId));
        result.put("familyAdminUid", new JsonLong(familyAdminUid));
        if (familyOrigin != null) {
            result.put("familyOrigin", new JsonString(familyOrigin));
        }
        result.put("cardId", new JsonString(cardInfo.cardId()));
        result.put("cardCurrency", new JsonString(cardInfo.currency()));
        result.put("cardMask", new JsonString(cardInfo.cardMask()));
        result.put("cardPaySystem", new JsonString(cardInfo.paySystem()));
        result.put("cardBound", JsonBoolean.valueOf(cardInfo.bound()));
        return result;
    }

    public String familyId() {
        return familyId;
    }

    public long familyAdminUid() {
        return familyAdminUid;
    }

    public String familyOrigin() {
        return familyOrigin;
    }

    public CardInfo cardInfo() {
        return cardInfo;
    }

    public FamilyMember memberInfo() {
        return memberInfo;
    }
}
