package ru.yandex.passport.familypay.backend;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;

import ru.yandex.client.pg.SqlQuery;
import ru.yandex.json.dom.BasicContainerFactory;

public class UserSettingsHandler extends UserHandlerBase {
    private static final SqlQuery USER_SETTINGS =
        new SqlQuery("user-settings.sql", UserInfoHandler.class);

    public UserSettingsHandler(final FamilypayBackend server) {
        super(server, true);
    }

    @Override
    protected void handle(final long uid, final RequestContext context) {
        context.server().pgClient().executeOnMaster(
            new SqlQuery(
                USER_SETTINGS.queryName(),
                USER_SETTINGS.query() + uid),
            context.session().listener(),
            new Callback(context, uid));
    }

    private static class Callback
        extends AbstractFamilypayCallback<RowSet<Row>>
    {
        private final long uid;

        Callback(final RequestContext context, final long uid) {
            super(context);
            this.uid = uid;
        }

        @Override
        public void completed(final RowSet<Row> rowSet) {
            try {
                if (rowSet.rowCount() <= 0) {
                    failed(ErrorType.USER_NOT_FOUND, null, null);
                } else {
                    UserInfo userInfo =
                        UserInfo.fromRow(rowSet.iterator().next(), uid, false);
                    sendResponse(
                        userInfo.toJson(
                            BasicContainerFactory.INSTANCE,
                            false));
                }
            } catch (RuntimeException e) {
                failed(
                    ErrorType.INTERNAL_ERROR,
                    "Failed to parse database response",
                    e);
            }
        }
    }
}

