package ru.yandex.passport.familypay.backend.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.client.pg.config.PgClientConfig;
import ru.yandex.client.pg.config.PgClientConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractFamilyPaybackConfigBuilder
    <T extends AbstractFamilyPaybackConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements FamilyPaybackConfig
{
    private PgClientConfigBuilder pgClientConfig;
    private HttpHostConfigBuilder blackboxConfig;
    private HttpHostConfigBuilder antifraudConfig;
    private LoggerConfigBuilder tskvLoggerConfig;
    private Map<String, ServiceConfigBuilder> servicesConfigs;

    protected AbstractFamilyPaybackConfigBuilder(
        final FamilyPaybackConfig config)
    {
        super(config);
        pgClientConfig(config.pgClientConfig());
        blackboxConfig(config.blackboxConfig());
        antifraudConfig(config.antifraudConfig());
        tskvLoggerConfig(config.tskvLoggerConfig());
        servicesConfigs(config.servicesConfigs());
    }

    protected AbstractFamilyPaybackConfigBuilder(
        final IniConfig config,
        final FamilyPaybackConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        pgClientConfig = PG_CLIENT.extract(config, defaults.pgClientConfig());
        blackboxConfig =
            BLACKBOX_CONFIG.extract(config, defaults.blackboxConfig());
        antifraudConfig =
            ANTIFRAUD_CONFIG.extract(config, defaults.antifraudConfig());
        tskvLoggerConfig =
            TSKV_LOGGER_CONFIG.extract(config, defaults.tskvLoggerConfig());

        IniConfig serviceConfigSection = config.section("service-config");
        Set<String> servicesNames = serviceConfigSection.sections().keySet();
        servicesConfigs = new HashMap<>(servicesNames.size() << 1);
        for (String service: servicesNames) {
            servicesConfigs.put(
                service,
                FamilyPaybackConfig.serviceConfigParser(service)
                    .extract(
                        serviceConfigSection,
                        ServiceConfigDefaults.INSTANCE));
        }
    }

    @Override
    public PgClientConfigBuilder pgClientConfig() {
        return pgClientConfig;
    }

    public T pgClientConfig(final PgClientConfig pgClientConfig) {
        this.pgClientConfig = new PgClientConfigBuilder(pgClientConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder blackboxConfig() {
        return blackboxConfig;
    }

    public T blackboxConfig(final HttpHostConfig blackboxConfig) {
        this.blackboxConfig = new HttpHostConfigBuilder(blackboxConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder antifraudConfig() {
        return antifraudConfig;
    }

    public T antifraudConfig(final HttpHostConfig antifraudConfig) {
        this.antifraudConfig = new HttpHostConfigBuilder(antifraudConfig);
        return self();
    }

    @Override
    public LoggerConfigBuilder tskvLoggerConfig() {
        return tskvLoggerConfig;
    }

    public T tskvLoggerConfig(final LoggerConfig tskvLoggerConfig) {
        this.tskvLoggerConfig = new LoggerConfigBuilder(tskvLoggerConfig);
        return self();
    }

    @Override
    public Map<String, ServiceConfigBuilder> servicesConfigs() {
        return servicesConfigs;
    }

    public T servicesConfigs(
        final Map<String, ? extends ServiceConfig> servicesConfigs)
    {
        this.servicesConfigs = new HashMap<>(servicesConfigs.size() << 1);
        for (Map.Entry<String, ? extends ServiceConfig> entry
            : servicesConfigs.entrySet())
        {
            this.servicesConfigs.put(
                entry.getKey(),
                new ServiceConfigBuilder(entry.getValue()));
        }
        return self();
    }
}

