package ru.yandex.passport.familypay.backend.config;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractServiceConfigBuilder
    <T extends AbstractServiceConfigBuilder<T>>
    implements ConfigBuilder<T>, ServiceConfig
{
    private long dayLimit;
    private boolean userTicketRequired;
    private boolean sendPushOnFamilyStart;
    private boolean sendPushOnFamilyChange;
    private boolean sendPushOnPayment;
    private Set<String> enabledServices;

    protected AbstractServiceConfigBuilder(final ServiceConfig config) {
        dayLimit(config.dayLimit());
        userTicketRequired(config.userTicketRequired());
        sendPushOnFamilyStart(config.sendPushOnFamilyStart());
        sendPushOnFamilyChange(config.sendPushOnFamilyChange());
        sendPushOnPayment(config.sendPushOnPayment());
        enabledServices(config.enabledServices());
    }

    protected AbstractServiceConfigBuilder(
        final IniConfig config,
        final ServiceConfig defaults)
        throws ConfigException
    {
        dayLimit = DAY_LIMIT.extract(config, defaults.dayLimit());
        userTicketRequired = USER_TICKET_REQUIRED.extract(
            config,
            defaults.userTicketRequired());
        sendPushOnFamilyStart =
            SEND_PUSH_ON_FAMILY_START.extract(
                config,
                defaults.sendPushOnFamilyStart());
        sendPushOnFamilyChange =
            SEND_PUSH_ON_FAMILY_CHANGE.extract(
                config,
                defaults.sendPushOnFamilyChange());
        sendPushOnPayment =
            SEND_PUSH_ON_PAYMENT.extract(
                config,
                defaults.sendPushOnPayment());
        enabledServices =
            ENABLED_SERVICES.extract(config, defaults.enabledServices());
    }

    @Override
    public long dayLimit() {
        return dayLimit;
    }

    public T dayLimit(final long dayLimit) {
        this.dayLimit = dayLimit;
        return self();
    }

    @Override
    public boolean userTicketRequired() {
        return userTicketRequired;
    }

    public T userTicketRequired(final boolean userTicketRequired) {
        this.userTicketRequired = userTicketRequired;
        return self();
    }

    @Override
    public boolean sendPushOnFamilyStart() {
        return sendPushOnFamilyStart;
    }

    public T sendPushOnFamilyStart(final boolean sendPushOnFamilyStart) {
        this.sendPushOnFamilyStart = sendPushOnFamilyStart;
        return self();
    }

    @Override
    public boolean sendPushOnFamilyChange() {
        return sendPushOnFamilyChange;
    }

    public T sendPushOnFamilyChange(final boolean sendPushOnFamilyChange) {
        this.sendPushOnFamilyChange = sendPushOnFamilyChange;
        return self();
    }

    @Override
    public boolean sendPushOnPayment() {
        return sendPushOnPayment;
    }

    public T sendPushOnPayment(final boolean sendPushOnPayment) {
        this.sendPushOnPayment = sendPushOnPayment;
        return self();
    }

    @Override
    public Set<String> enabledServices() {
        return enabledServices;
    }

    public T enabledServices(final Set<String> enabledServices) {
        this.enabledServices = new HashSet<>(enabledServices);
        return self();
    }
}

