package ru.yandex.passport.familypay.backend.config;

import java.util.Map;

import ru.yandex.client.pg.config.ImmutablePgClientConfig;
import ru.yandex.client.pg.config.PgClientConfig;
import ru.yandex.client.pg.config.PgClientConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.parser.config.SectionConfig;

public interface FamilyPaybackConfig extends HttpProxyConfig {
    SectionConfig<
        PgClientConfig,
        ImmutablePgClientConfig,
        PgClientConfigBuilder>
        PG_CLIENT = new SectionConfig<>(
            "pg-client",
            PgClientConfigBuilder::new,
            ImmutablePgClientConfig::new);

    SectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        BLACKBOX_CONFIG = new SectionConfig<>(
            "blackbox",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new);

    SectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        ANTIFRAUD_CONFIG = new SectionConfig<>(
            "antifraud",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new);

    SectionConfig<
        LoggerConfig,
        ImmutableLoggerConfig,
        LoggerConfigBuilder>
        TSKV_LOGGER_CONFIG = new SectionConfig<>(
            "tskvlog",
            LoggerConfigBuilder::new,
            ImmutableLoggerConfig::new);

    static SectionConfig<
        ServiceConfig,
        ImmutableServiceConfig,
        ServiceConfigBuilder>
    serviceConfigParser(final String service) {
        return new SectionConfig<>(
            service,
            ServiceConfigBuilder::new,
            ImmutableServiceConfig::new);
    }

    PgClientConfig pgClientConfig();

    HttpHostConfig blackboxConfig();

    HttpHostConfig antifraudConfig();

    LoggerConfig tskvLoggerConfig();

    Map<String, ? extends ServiceConfig> servicesConfigs();
}

