package ru.yandex.passport.familypay.backend.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class FamilyPaybackConfigBuilder
    extends AbstractFamilyPaybackConfigBuilder<FamilyPaybackConfigBuilder>
{
    public FamilyPaybackConfigBuilder() {
        super(FamilyPaybackConfigDefaults.INSTANCE);
    }

    public FamilyPaybackConfigBuilder(final FamilyPaybackConfig config) {
        super(config);
    }

    public FamilyPaybackConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, FamilyPaybackConfigDefaults.INSTANCE);
    }

    public FamilyPaybackConfigBuilder(
        final IniConfig config,
        final FamilyPaybackConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public FamilyPaybackConfigBuilder self() {
        return this;
    }

    public ImmutableFamilyPaybackConfig build() throws ConfigException {
        return new ImmutableFamilyPaybackConfig(this);
    }
}

