package ru.yandex.passport.familypay.backend.config;

import java.util.Collections;
import java.util.Map;

import ru.yandex.client.pg.config.PgClientConfig;
import ru.yandex.client.pg.config.PgClientConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.PureLoggerConfigDefaults;

public class FamilyPaybackConfigDefaults
    extends HttpProxyConfigDefaults
    implements FamilyPaybackConfig
{
    public static final FamilyPaybackConfigDefaults INSTANCE =
        new FamilyPaybackConfigDefaults();

    protected FamilyPaybackConfigDefaults() {
    }

    @Override
    public String name() {
        return "Familypay";
    }

    @Override
    public PgClientConfig pgClientConfig() {
        return PgClientConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig blackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig antifraudConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public LoggerConfig tskvLoggerConfig() {
        return PureLoggerConfigDefaults.INSTANCE;
    }

    @Override
    public Map<String, ServiceConfig> servicesConfigs() {
        return Collections.emptyMap();
    }
}

