package ru.yandex.passport.familypay.backend.config;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.client.pg.config.ImmutablePgClientConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableFamilyPaybackConfig
    extends ImmutableHttpProxyConfig
    implements FamilyPaybackConfig
{
    private final ImmutablePgClientConfig pgClientConfig;
    private final ImmutableHttpHostConfig blackboxConfig;
    private final ImmutableHttpHostConfig antifraudConfig;
    private final ImmutableLoggerConfig tskvLoggerConfig;
    private final Map<String, ImmutableServiceConfig> servicesConfigs;

    public ImmutableFamilyPaybackConfig(final FamilyPaybackConfig config)
        throws ConfigException
    {
        super(config);
        pgClientConfig = PG_CLIENT.validate(config.pgClientConfig());
        blackboxConfig = BLACKBOX_CONFIG.validate(config.blackboxConfig());
        antifraudConfig = ANTIFRAUD_CONFIG.validate(config.antifraudConfig());
        tskvLoggerConfig =
            TSKV_LOGGER_CONFIG.validate(config.tskvLoggerConfig());
        Map<String, ? extends ServiceConfig> servicesConfigs =
            config.servicesConfigs();
        this.servicesConfigs = new HashMap<>(servicesConfigs.size() << 1);
        for (Map.Entry<String, ? extends ServiceConfig> entry
            : servicesConfigs.entrySet())
        {
            String name = entry.getKey();
            this.servicesConfigs.put(
                name,
                FamilyPaybackConfig.serviceConfigParser(name)
                    .validate(entry.getValue()));
        }
    }

    @Override
    public ImmutablePgClientConfig pgClientConfig() {
        return pgClientConfig;
    }

    @Override
    public ImmutableHttpHostConfig antifraudConfig() {
        return antifraudConfig;
    }

    @Override
    public ImmutableHttpHostConfig blackboxConfig() {
        return blackboxConfig;
    }

    @Override
    public ImmutableLoggerConfig tskvLoggerConfig() {
        return tskvLoggerConfig;
    }

    @Override
    public Map<String, ImmutableServiceConfig> servicesConfigs() {
        return servicesConfigs;
    }
}

