package ru.yandex.passport.familypay.backend.config;

import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableServiceConfig implements ImmutableConfig, ServiceConfig {
    private final long dayLimit;
    private final boolean userTicketRequired;
    private final boolean sendPushOnFamilyStart;
    private final boolean sendPushOnFamilyChange;
    private final boolean sendPushOnPayment;
    private final Set<String> enabledServices;

    public ImmutableServiceConfig(final ServiceConfig config)
        throws ConfigException
    {
        dayLimit = DAY_LIMIT.validate(config.dayLimit());
        userTicketRequired =
            USER_TICKET_REQUIRED.validate(config.userTicketRequired());
        sendPushOnFamilyStart =
            SEND_PUSH_ON_FAMILY_START.validate(config.sendPushOnFamilyStart());
        sendPushOnFamilyChange =
            SEND_PUSH_ON_FAMILY_CHANGE.validate(
                config.sendPushOnFamilyChange());
        sendPushOnPayment =
            SEND_PUSH_ON_PAYMENT.validate(config.sendPushOnPayment());
        enabledServices = ENABLED_SERVICES.validate(config.enabledServices());
    }

    @Override
    public long dayLimit() {
        return dayLimit;
    }

    @Override
    public boolean userTicketRequired() {
        return userTicketRequired;
    }

    @Override
    public boolean sendPushOnFamilyStart() {
        return sendPushOnFamilyStart;
    }

    @Override
    public boolean sendPushOnFamilyChange() {
        return sendPushOnFamilyChange;
    }

    @Override
    public boolean sendPushOnPayment() {
        return sendPushOnPayment;
    }

    @Override
    public Set<String> enabledServices() {
        return enabledServices;
    }
}

