package ru.yandex.passport.familypay.backend.config;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.CollectionValidator;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface ServiceConfig {
    ParameterConfig<Long> DAY_LIMIT =
        new ParameterConfig<>(
            "day-limit",
            Long::valueOf,
            PositiveValidator.instance());
    ParameterConfig<Boolean> USER_TICKET_REQUIRED =
        new ParameterConfig<Boolean>(
            "user-ticket-required",
            BooleanParser.INSTANCE,
            GenericFunction.identity());
    ParameterConfig<Boolean> SEND_PUSH_ON_FAMILY_START =
        new ParameterConfig<Boolean>(
            "send-push-on-family-start",
            BooleanParser.INSTANCE,
            GenericFunction.identity());
    ParameterConfig<Boolean> SEND_PUSH_ON_FAMILY_CHANGE =
        new ParameterConfig<Boolean>(
            "send-push-on-family-change",
            BooleanParser.INSTANCE,
            GenericFunction.identity());
    ParameterConfig<Boolean> SEND_PUSH_ON_PAYMENT =
        new ParameterConfig<Boolean>(
            "send-push-on-payment",
            BooleanParser.INSTANCE,
            GenericFunction.identity());
    ParameterConfig<Set<String>> ENABLED_SERVICES =
        new ParameterConfig<>(
            "enabled-services",
            new CollectionParser<>(NonEmptyValidator.TRIMMED, HashSet::new),
            new CollectionValidator<String, Set<String>>(
                NonEmptyValidator.TRIMMED)
                .andThen(HashSet::new));

    long dayLimit();

    boolean userTicketRequired();

    boolean sendPushOnFamilyStart();

    boolean sendPushOnFamilyChange();

    boolean sendPushOnPayment();

    // If empty, then all services allowed
    Set<String> enabledServices();
}

