package ru.yandex.passport.familypay.backend.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ServiceConfigBuilder
    extends AbstractServiceConfigBuilder<ServiceConfigBuilder>
{
    public ServiceConfigBuilder() {
        super(ServiceConfigDefaults.INSTANCE);
    }

    public ServiceConfigBuilder(final ServiceConfig config) {
        super(config);
    }

    public ServiceConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, ServiceConfigDefaults.INSTANCE);
    }

    public ServiceConfigBuilder(
        final IniConfig config,
        final ServiceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ServiceConfigBuilder self() {
        return this;
    }

    public ImmutableServiceConfig build() throws ConfigException {
        return new ImmutableServiceConfig(this);
    }
}

