WITH members AS MATERIALIZED (
    SELECT
        unnest($15::BIGINT[]) AS uid,
        unnest($16::BOOLEAN[]) AS has_secure_phone,
        $1::TEXT AS family_id
),
new_family AS MATERIALIZED (
    INSERT INTO familypay.family(
        family_id,
        admin_uid,
        card_id,
        card_mask,
        card_currency,
        card_pay_system,
        card_bound,
        origin,
        default_unlim,
        default_day_limit,
        default_week_limit,
        default_month_limit,
        default_total_limit,
        default_allowed_services
    )
    VALUES (
        $1,
        $2,
        $3,
        $4,
        $5,
        $6,
        $7,
        $8,
        $9,
        $10,
        $11,
        $12,
        $13,
        $14::TEXT[]
    )
    ON CONFLICT
        DO NOTHING
    RETURNING
        *
),
old_family AS MATERIALIZED (
    SELECT
        family_id,
        admin_uid,
        card_id,
        card_mask,
        card_currency,
        card_pay_system,
        card_bound,
        origin,
        default_unlim,
        default_day_limit,
        default_week_limit,
        default_month_limit,
        default_total_limit,
        default_allowed_services,
        TRUE as is_new
    FROM
        new_family
    UNION
    SELECT
        family_id,
        admin_uid,
        card_id,
        card_mask,
        card_currency,
        card_pay_system,
        card_bound,
        origin,
        default_unlim,
        default_day_limit,
        default_week_limit,
        default_month_limit,
        default_total_limit,
        default_allowed_services,
        FALSE as is_new
    FROM
        familypay.family
    WHERE
        family_id = $1
        AND admin_uid = $2
        AND card_id = $3
        AND card_mask = $4
        AND card_currency = $5
        AND card_pay_system = $6
        AND card_bound = $7
        AND origin = $8
        AND default_unlim = $9
        AND default_day_limit = $10
        AND default_week_limit = $11
        AND default_month_limit = $12
        AND default_total_limit = $13
        AND (default_allowed_services = $14::TEXT[]
            OR ((default_allowed_services IS NULL) AND ($14::TEXT[] IS NULL)))
    LIMIT 1),
inserted_family AS MATERIALIZED (
    INSERT INTO familypay.family_member (
        uid,
        family_id,
        enabled,
        unlim,
        has_secure_phone,
        limit_currency,
        day_limit,
        week_limit,
        month_limit,
        total_limit,
        allowed_services)
    SELECT
        m.uid,
        f.family_id,
        TRUE,
        f.default_unlim,
        m.has_secure_phone,
        f.card_currency,
        f.default_day_limit,
        f.default_week_limit,
        f.default_month_limit,
        f.default_total_limit,
        f.default_allowed_services
    FROM
        old_family f
        JOIN members m ON m.family_id = f.family_id
    ON CONFLICT (uid)
        DO UPDATE SET
            uid = EXCLUDED.uid
)
SELECT
    is_new
FROM
    old_family
