WITH user_payments AS MATERIALIZED (
    SELECT
        amount, timestamp
    FROM
        familypay.payment
    WHERE
        initiator_uid = $1
        AND (status = 'started' OR status = 'completed')
)
SELECT
    family.admin_uid,
    day.day_amount,
    week.week_amount,
    month.month_amount,
    total.total_amount,
    member.unlim,
    member.limit_currency,
    member.day_limit,
    member.week_limit,
    member.month_limit,
    member.total_limit
FROM
    familypay.family_member member
    JOIN familypay.family ON family.family_id = member.family_id
    LEFT JOIN (
        SELECT
            sum(amount) AS day_amount,
            $1 AS initiator_uid
        FROM
            user_payments
        WHERE
            timestamp > (CURRENT_TIMESTAMP - interval '1 day')) day ON member.uid = day.initiator_uid
    LEFT JOIN (
        SELECT
            sum(amount) AS week_amount,
            $1 AS initiator_uid
        FROM
            user_payments
        WHERE
            date_trunc('week', timestamp) = date_trunc('week', CURRENT_TIMESTAMP)) week ON member.uid = week.initiator_uid
    LEFT JOIN (
        SELECT
            sum(amount) AS month_amount,
            $1 AS initiator_uid
        FROM
            user_payments
        WHERE
            date_trunc('month', timestamp) = date_trunc('month', CURRENT_TIMESTAMP)) month ON member.uid = week.initiator_uid
    LEFT JOIN (
        SELECT
            sum(amount) AS total_amount,
            $1 AS initiator_uid
        FROM
            user_payments) total ON member.uid = total.initiator_uid
WHERE
    member.uid = $1
