INSERT INTO familypay.payment (
    id,
    status,
    initiator_uid,
    card_id,
    amount,
    service_id)
SELECT
    $1,
    'started',
    m.uid,
    $3,
    $4,
    $6
FROM
    familypay.family f
    JOIN familypay.family_member m ON f.family_id = m.family_id
WHERE
    m.uid = $2
    AND m.enabled = TRUE
    AND f.card_bound = TRUE
    AND (m.allowed_services IS NULL OR $5 = ANY(m.allowed_services))
    AND m.limit_currency = $7
ON CONFLICT (id) DO UPDATE SET id = EXCLUDED.id
WHERE
    familypay.payment.status = 'started'
    AND familypay.payment.amount = $4
