WITH uid_family AS MATERIALIZED (
    SELECT
        family_id
    FROM
        familypay.family_member
    WHERE
        uid = $1),
family_payments AS MATERIALIZED (
    SELECT
        initiator_uid, amount, timestamp
    FROM
        familypay.family_member m
    JOIN
        uid_family uf ON uf.family_id = m.family_id
    JOIN
        familypay.payment p ON m.uid = p.initiator_uid
    WHERE
        status = 'started' OR status = 'completed'
)
SELECT
    f.family_id,
    f.admin_uid,
    f.card_id,
    f.card_mask,
    f.card_currency,
    f.card_pay_system,
    f.card_bound,
    f.origin,
    f.default_unlim,
    f.default_day_limit,
    f.default_week_limit,
    f.default_month_limit,
    f.default_total_limit,
    f.default_allowed_services,
    m.uid,
    m.enabled,
    m.unlim,
    m.has_secure_phone,
    m.limit_currency,
    m.day_limit,
    m.week_limit,
    m.month_limit,
    m.total_limit,
    m.allowed_services,
    ed.day_amount,
    ew.week_amount,
    em.month_amount,
    et.total_amount
FROM
    familypay.family f
JOIN
    uid_family uf ON uf.family_id = f.family_id
JOIN
    familypay.family_member m ON m.family_id = f.family_id
LEFT JOIN (
    SELECT
        sum(amount) AS day_amount,
        initiator_uid
    FROM
        family_payments
    WHERE
        timestamp > (CURRENT_TIMESTAMP - interval '1 day')
    GROUP BY
        initiator_uid) ed ON ed.initiator_uid = m.uid
LEFT JOIN (
    SELECT
        sum(amount) AS week_amount,
        initiator_uid
    FROM
        family_payments
    WHERE
        date_trunc('week', timestamp) = date_trunc('week', CURRENT_TIMESTAMP)
    GROUP BY
        initiator_uid) ew ON ew.initiator_uid = m.uid
LEFT JOIN (
    SELECT
        sum(amount) AS month_amount,
        initiator_uid
    FROM
        family_payments
    WHERE
        date_trunc('month', timestamp) = date_trunc('month', CURRENT_TIMESTAMP)
    GROUP BY
        initiator_uid) em ON em.initiator_uid = m.uid
LEFT JOIN (
    SELECT
        sum(amount) AS total_amount,
        initiator_uid
    FROM
        family_payments
    GROUP BY
        initiator_uid) et ON et.initiator_uid = m.uid
ORDER BY
    m.uid
