WITH real_uid AS MATERIALIZED (
    SELECT
        m.uid
    FROM
        familypay.family_member m
        JOIN familypay.family f ON f.family_id = m.family_id
    WHERE
        m.uid = $1
        AND f.admin_uid = $2),
deleted_payments AS MATERIALIZED (
    DELETE FROM familypay.payment p
    USING real_uid r
    WHERE p.initiator_uid = r.uid)
UPDATE
    familypay.expenses AS e
SET
    total = 0
FROM real_uid r
WHERE e.uid = r.uid
