WITH actual_members AS MATERIALIZED (
    SELECT
        $1::TEXT as family_id,
        unnest($2::BIGINT[]) AS uid,
        unnest($3::BOOLEAN[]) AS has_secure_phone
)
INSERT INTO familypay.family_member (
    uid,
    family_id,
    enabled,
    unlim,
    has_secure_phone,
    limit_currency,
    day_limit,
    week_limit,
    month_limit,
    total_limit,
    allowed_services)
SELECT
    a.uid,
    a.family_id,
    TRUE,
    f.default_unlim,
    a.has_secure_phone,
    f.card_currency,
    f.default_day_limit,
    f.default_week_limit,
    f.default_month_limit,
    f.default_total_limit,
    f.default_allowed_services
FROM
    actual_members a
    JOIN familypay.family f ON a.family_id = f.family_id
ON CONFLICT (uid) DO NOTHING
