WITH updated_uids AS MATERIALIZED (
    UPDATE
        familypay.family_member AS m
    SET
        unlim = coalesce($4, unlim),
        limit_currency = coalesce($5, old.limit_currency),
        day_limit = coalesce($6, day_limit),
        week_limit = coalesce($7, week_limit),
        month_limit = coalesce($8, month_limit),
        total_limit = coalesce($9, total_limit),
        allowed_services =
            CASE
                WHEN $12 = TRUE THEN NULL
                ELSE coalesce($10::TEXT[], allowed_services)
            END,
        enabled = coalesce($11, enabled)
    FROM (
        SELECT
            uid,
            limit_currency
        FROM familypay.family_member m
        JOIN familypay.family f ON f.family_id = m.family_id
        WHERE
            m.family_id = $1
            AND f.admin_uid = $2
            AND uid = $3
        FOR UPDATE) old
    WHERE m.uid = old.uid
    RETURNING
        m.uid, m.limit_currency, old.limit_currency AS old_currency),
changed_currency AS MATERIALIZED (
    SELECT
        uid
    FROM
        updated_uids
    WHERE
        limit_currency != old_currency),
deleted_payments AS MATERIALIZED (
    DELETE FROM familypay.payment p
    USING changed_currency c
    WHERE p.initiator_uid = c.uid),
deleted_expenses AS MATERIALIZED (
    UPDATE
        familypay.expenses e
    SET
        total = 0
    FROM
        changed_currency c
    WHERE
        e.uid = c.uid)
SELECT uid FROM updated_uids
