WITH user_payments AS MATERIALIZED (
    SELECT
        amount, timestamp
    FROM
        familypay.payment
    WHERE
        initiator_uid = $1
        AND (status = 'started' OR status = 'completed')
)
SELECT
    f.family_id,
    f.admin_uid,
    f.origin,
    f.card_id,
    f.card_mask,
    f.card_currency,
    f.card_pay_system,
    f.card_bound,
    m.enabled,
    m.unlim,
    m.has_secure_phone,
    m.limit_currency,
    m.day_limit,
    m.week_limit,
    m.month_limit,
    m.total_limit,
    m.allowed_services,
    ed.day_amount,
    ew.week_amount,
    em.month_amount,
    et.total_amount
FROM
    familypay.family_member m
JOIN
    familypay.family f ON m.family_id = f.family_id
LEFT JOIN (
    SELECT
        sum(amount) AS day_amount,
        $1 AS initiator_uid
    FROM
        user_payments
    WHERE
        timestamp > (CURRENT_TIMESTAMP - interval '1 day')) ed ON m.uid = ed.initiator_uid
LEFT JOIN (
    SELECT
        sum(amount) AS week_amount,
        $1 AS initiator_uid
    FROM
        user_payments
    WHERE
        date_trunc('week', timestamp) = date_trunc('week', CURRENT_TIMESTAMP)) ew ON m.uid = ew.initiator_uid
LEFT JOIN (
    SELECT
        sum(amount) AS month_amount,
        $1 AS initiator_uid
    FROM
        user_payments
    WHERE
        date_trunc('month', timestamp) = date_trunc('month', CURRENT_TIMESTAMP)) em ON m.uid = em.initiator_uid
LEFT JOIN (
    SELECT
        sum(amount) AS total_amount,
        $1 AS initiator_uid
    FROM
        user_payments) et ON m.uid = et.initiator_uid
WHERE
    uid = $1
    AND (m.allowed_services IS NULL OR $2 = ANY(m.allowed_services))
