#!/bin/bash
set -exo pipefail

export LOGROTATE_DAYS=14

export FAMILYPAY_BACKEND_PORT=80
export FAMILYPAY_BACKEND_HTTPS_PORT=443

export SERVICE_CONFIG=empty.conf
export TVM_API_HOST=https://tvm-api.yandex.net
export TVM_CLIENT_ID=2021718
export SO_FRAUD_HOST=https://fraud.so.yandex-team.ru
export SO_FRAUD_TVM_CLIENT_ID=2019898
export PASSPORT_TVM_CLIENT_ID=2010646,2021183
export TAXI_TVM_CLIENT_ID=2011198
export TAXI_LK_TVM_CLIENT_ID=2031266
export BALANCER_NAME=familypay-backend.so.yandex.net
export BLACKBOX_HOST=http://blackbox.yandex.net
export BLACKBOX_TVM_CLIENT_ID=222
export PGHOSTS=https://sas-r5fj1d506z0mgzcx.db.yandex.net:6432,https://vla-5k7f371e0zio62l8.db.yandex.net:6432
export PGDATABASE=familypaydb
export PGUSER=familyguy
export BUNKER_URI="http://bunker-api.yandex.net/v1/cat?node=/fpay/config&version=stable"

export CPU_CORES=$(echo $CPU_LIMIT | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
export MEMORY_LIMIT=$(echo $MEM_LIMIT | gawk '{print int($1*0.8)}')

GB0_5=$(( 512*1024*1024 ))
export MEMORY_GAP=${MEMORY_GAP:-$GB0_5}

if [ "$INSTANCE_TAG_CTYPE" = "test" ]
then
    export TVM_CLIENT_ID=2021716
    export SO_FRAUD_HOST=https://fraud-test.so.yandex-team.ru
    export SO_FRAUD_TVM_CLIENT_ID=2024973
    export PASSPORT_TVM_CLIENT_ID=2010644,2021181
    export TAXI_TVM_CLIENT_ID=2011196
    export TAXI_LK_TVM_CLIENT_ID=2031264
    export BALANCER_NAME=familypay-backend-test.so.yandex.net
    export BLACKBOX_HOST=http://blackbox-test.yandex.net
    export BLACKBOX_TVM_CLIENT_ID=224
    export PGHOSTS=https://sas-6k1c2ms63uyo5mxr.db.yandex.net:6432,https://vla-z7425qeprd4gglg1.db.yandex.net:6432
    export BUNKER_URI="http://bunker-api-dot.yandex.net/v1/cat?node=/fpay/config_test&version=stable"
fi

