#!/bin/bash
set -exo pipefail

if [ x"$HOSTNAME" != x"familypay-backend-1.sas.yp-c.yandex.net" ]
then
    echo "Not a primary host, skipping database dump"
    exit 0
fi

source config.sh

status_file=/logs/dump-database-status
status_file_time_mark=${status_file}.tmp

touch $status_file_time_mark
now_date="$(stat -c %y $status_file_time_mark 2>/dev/null|cut -d' ' -f1)"

if [ -f $status_file ]
then
    status_file_date="$(stat -c %y $status_file 2>/dev/null|cut -d' ' -f1)"
    if [ x"$status_file_date" == x"$now_date" ]
    then
        echo "Database already dumped today, skipping database dump"
        exit 0
    fi
fi

psql "host=sas-r5fj1d506z0mgzcx.db.yandex.net,vla-5k7f371e0zio62l8.db.yandex.net port=6432 sslmode=verify-full dbname=familypaydb user=familyguy sslrootcert=allCAs.pem" -o /logs/dump-database.json -f dump-database.sql

yt_path=//home/passport/production/family_pay/$now_date
yt_schema='<"strict"=%true;"unique_keys"=%false;>[{"type"="int64";"required"=%true;"name"="uid";};{"type"="string";"required"=%true;"name"="family_id";};{"type"="int64";"required"=%true;"name"="admin_uid";};{"type"="string";"required"=%true;"name"="role";};{"type"="any";"type_v3"={"type_name"="list";"item"="string";};"required"=%true;"name"="allowed_services";};{"type"="int64";"required"=%true;"name"="limit";};{"type"="string";"required"=%true;"name"="limit_mode";};{"type"="string";"required"=%true;"name"="limit_currency";};{"type"="string";"required"=%true;"name"="origin";};{"type"="string";"required"=%true;"name"="card_id";};{"type"="string";"required"=%true;"name"="card_mask";};{"type"="boolean";"required"=%true;"name"="card_bound";};{"type"="boolean";"required"=%true;"name"="familypay_enabled";};{"type"="boolean";"required"=%true;"name"="has_secure_phone";}]'
full_yt_path="<schema=${yt_schema}>${yt_path}"

tail -n+3 /logs/dump-database.json | head -n-2 | yt write --proxy hahn --format json $full_yt_path

mv $status_file_time_mark $status_file

