SELECT row_to_json(t)
FROM (
    SELECT
        m.uid,
        f.family_id,
        f.admin_uid,
        CASE
            WHEN m.uid = f.admin_uid THEN 'admin'
            ELSE 'member'
        END AS role,
        CASE
            WHEN m.allowed_services IS NULL THEN '{all}'
            ELSE m.allowed_services
        END AS allowed_services,
        CASE
            WHEN m.day_limit < 9223372036854775807 THEN m.day_limit
            WHEN m.week_limit < 9223372036854775807 THEN m.week_limit
            WHEN m.month_limit < 9223372036854775807 THEN m.month_limit
            ELSE m.total_limit
        END AS limit,
        CASE
            WHEN m.unlim THEN 'unlim'
            WHEN m.day_limit < 9223372036854775807 THEN 'day'
            WHEN m.week_limit < 9223372036854775807 THEN 'week'
            WHEN m.month_limit < 9223372036854775807 THEN 'month'
            ELSE 'total'
        END AS limit_mode,
        m.limit_currency,
        f.origin,
        f.card_id,
        f.card_mask,
        f.card_bound,
        m.enabled AS familypay_enabled,
        m.has_secure_phone
    FROM
        familypay.family_member m
    JOIN familypay.family f ON m.family_id = f.family_id
) t;
