package ru.yandex.passport.familypay.services;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.charset.Decoder;
import ru.yandex.http.util.ByteArrayProcessableWithContentType;
import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;

public class FamilypayServices {
    private final Map<Long, ServiceInfo> services = new HashMap<>();

    public FamilypayServices(final ByteArrayProcessableWithContentType data)
        throws IOException, HttpException
    {
        Decoder decoder = new Decoder(data.contentType().getCharset());
        data.data().processWith(decoder);
        try {
            JsonMap map =
                TypesafeValueContentHandler.parse(decoder).get("services")
                    .asMap();
            for (Map.Entry<String, JsonObject> entry: map.entrySet()) {
                String name = entry.getKey();
                JsonMap config = entry.getValue().asMap();
                JsonList allowedUids =
                    config.get("allowed_uids").asListOrNull();
                Set<Long> uids;
                if (allowedUids == null) {
                    uids = null;
                } else {
                    int size = allowedUids.size();
                    uids = new HashSet<>(size << 1);
                    for (int i = 0; i < size; ++i) {
                        uids.add(allowedUids.get(i).asLong());
                    }
                }
                ServiceInfo info = new ServiceInfo(name, uids);
                JsonList ids = config.get("ids").asList();
                int size = ids.size();
                for (int i = 0; i < size; ++i) {
                    Long id = ids.get(i).asLong();
                    ServiceInfo oldInfo = services.put(id, info);
                    if (oldInfo != null) {
                        throw new ServiceUnavailableException(
                            "Can't add service_id " + id + " for service '"
                            + name + "' as it already registered for service '"
                            + oldInfo.name + '\'');
                    }
                }
            }
        } catch (JsonException e) {
            throw new ServiceUnavailableException(
                "Failed to parse json < " + decoder + '>',
                e);
        }
    }

    public String serviceName(final long serviceId, final long uid) {
        ServiceInfo info = services.get(serviceId);
        if (info == null
            || (info.allowedUids != null && !info.allowedUids.contains(uid)))
        {
            return null;
        } else {
            return info.name;
        }
    }

    private static class ServiceInfo {
        private final String name;
        private final Set<Long> allowedUids;

        ServiceInfo(final String name, final Set<Long> allowedUids) {
            this.name = name;
            this.allowedUids = allowedUids;
        }
    }
}

