package ru.yandex.passport.familypay.snitch;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.FixedMultiFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.tskv.TskvAsyncConsumer;
import ru.yandex.tskv.TskvException;
import ru.yandex.tskv.TskvRecord;

public class NotifyFamilypayHandler
    implements HttpAsyncRequestHandler<List<TskvRecord>>
{
    protected final Snitch server;

    public NotifyFamilypayHandler(final Snitch server) {
        this.server = server;
    }

    @Override
    public TskvAsyncConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException
    {
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity =
                ((HttpEntityEnclosingRequest) request).getEntity();
            if (entity.getContentLength() != 0) {
                return new TskvAsyncConsumer(entity);
            }
        }
        throw new BadRequestException("Payload expected");
    }

    @Override
    public void handle(
        final List<TskvRecord> records,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        int i = 0;
        Set<Long> uids = new HashSet<>();
        try {
            int size = records.size();
            for (; i < size; ++i) {
                TskvRecord record = records.get(i);
                String entity = record.getString("entity", "");
                if (!entity.equals("phones.secure")) {
                    session.logger().info(
                        "Skipping unsupported entity type '" + entity
                        + "' at record #" + i);
                    continue;
                }
                uids.add(record.getLong("uid"));
            }
        } catch (TskvException e) {
            throw new BadRequestException(
                "Failed to parse record #" + i + " in records: " + records,
                e);
        }
        int size = uids.size();
        if (size == 0) {
            session.logger().fine("No processable entities found");
            session.response(HttpStatus.SC_OK);
        } else {
            session.logger().fine("Users with phones changed: " + uids);
            FixedMultiFutureCallback<Void> callback =
                new FixedMultiFutureCallback<>(
                    new Callback(session),
                    size);
            AsyncClient client = server.familypayClient().adjust(context);
            Supplier<? extends HttpClientContext> contextGenerator =
                session.listener().createContextGeneratorFor(client);
            i = 0;
            for (Long uid: uids) {
                client.execute(
                    server.familypayHost(),
                    new BasicAsyncRequestProducerGenerator(
                        "/update-phone-info?uid=" + uid),
                    EmptyAsyncConsumerFactory.ANY_GOOD,
                    contextGenerator,
                    callback.callback(i++));
            }
        }
    }

    private static class Callback
        extends AbstractProxySessionCallback<Object>
    {
        Callback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Object result) {
            session.response(HttpStatus.SC_OK);
        }
    }
}

