package ru.yandex.passport.familypay.snitch;

import java.io.IOException;

import org.apache.http.HttpHost;

import ru.yandex.collection.Pattern;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.server.async.PingHandler;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.passport.familypay.snitch.config.ImmutableSnitchConfig;

public class Snitch extends HttpProxy<ImmutableSnitchConfig> {
    private final HttpHost familypayHost;
    private final AsyncClient familypayClient;
    private final HttpHost yandexpayHost;
    private final AsyncClient yandexpayClient;

    public Snitch(final ImmutableSnitchConfig config) throws IOException {
        super(config);
        ImmutableHttpHostConfig familypayConfig =
            config.familypayConfig();
        familypayHost = familypayConfig.host();
        familypayClient = client("Familypay", familypayConfig);

        ImmutableHttpHostConfig yandexpayConfig =
            config.yandexpayConfig();
        yandexpayHost = yandexpayConfig.host();
        yandexpayClient = client("Yandexpay", yandexpayConfig);

        register(
            new Pattern<>("/notify-familypay", false),
            new NotifyFamilypayHandler(this));

        register(
            new Pattern<>("/notify-yandexpay", false),
            new NotifyYandexpayHandler(this));

        register(new Pattern<>("/user-glogout", false), new PingHandler(this));
    }

    public HttpHost familypayHost() {
        return familypayHost;
    }

    public AsyncClient familypayClient() {
        return familypayClient;
    }

    public HttpHost yandexpayHost() {
        return yandexpayHost;
    }

    public AsyncClient yandexpayClient() {
        return yandexpayClient;
    }
}

