package ru.yandex.passport.familypay.snitch.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractSnitchConfigBuilder
    <T extends AbstractSnitchConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements SnitchConfig
{
    private HttpHostConfigBuilder familypayConfig;
    private HttpHostConfigBuilder yandexpayConfig;

    protected AbstractSnitchConfigBuilder(final SnitchConfig config) {
        super(config);
        familypayConfig(config.familypayConfig());
        yandexpayConfig(config.yandexpayConfig());
    }

    protected AbstractSnitchConfigBuilder(
        final IniConfig config,
        final SnitchConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        familypayConfig =
            FAMILYPAY_CONFIG.extract(config, defaults.familypayConfig());
        yandexpayConfig =
            YANDEXPAY_CONFIG.extract(config, defaults.yandexpayConfig());
    }

    @Override
    public HttpHostConfigBuilder familypayConfig() {
        return familypayConfig;
    }

    public T familypayConfig(final HttpHostConfig familypayConfig) {
        this.familypayConfig = new HttpHostConfigBuilder(familypayConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder yandexpayConfig() {
        return yandexpayConfig;
    }

    public T yandexpayConfig(final HttpHostConfig yandexpayConfig) {
        this.yandexpayConfig = new HttpHostConfigBuilder(yandexpayConfig);
        return self();
    }
}

