package ru.yandex.passport.familypay.snitch.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableSnitchConfig
    extends ImmutableHttpProxyConfig
    implements SnitchConfig
{
    private final ImmutableHttpHostConfig familypayConfig;
    private final ImmutableHttpHostConfig yandexpayConfig;

    public ImmutableSnitchConfig(final SnitchConfig config)
        throws ConfigException
    {
        super(config);
        familypayConfig = FAMILYPAY_CONFIG.validate(config.familypayConfig());
        yandexpayConfig = YANDEXPAY_CONFIG.validate(config.yandexpayConfig());
    }

    @Override
    public ImmutableHttpHostConfig familypayConfig() {
        return familypayConfig;
    }

    @Override
    public ImmutableHttpHostConfig yandexpayConfig() {
        return yandexpayConfig;
    }
}

