package ru.yandex.passport.familypay.snitch.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.parser.config.SectionConfig;

public interface SnitchConfig extends HttpProxyConfig {
    SectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        FAMILYPAY_CONFIG = new SectionConfig<>(
            "familypay",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new);

    SectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        YANDEXPAY_CONFIG = new SectionConfig<>(
            "yandexpay",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new);

    HttpHostConfig familypayConfig();

    HttpHostConfig yandexpayConfig();
}

