package ru.yandex.passport.familypay.snitch.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class SnitchConfigBuilder
    extends AbstractSnitchConfigBuilder<SnitchConfigBuilder>
{
    public SnitchConfigBuilder() {
        super(SnitchConfigDefaults.INSTANCE);
    }

    public SnitchConfigBuilder(final SnitchConfig config) {
        super(config);
    }

    public SnitchConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, SnitchConfigDefaults.INSTANCE);
    }

    public SnitchConfigBuilder(
        final IniConfig config,
        final SnitchConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public SnitchConfigBuilder self() {
        return this;
    }

    public ImmutableSnitchConfig build() throws ConfigException {
        return new ImmutableSnitchConfig(this);
    }
}

