#pragma once

#include <cv/library/imgcore/opencvutils/cvmat_img_preparer.h>

#include <util/generic/map.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <util/system/types.h>

namespace NNeuralNet {
    class TDanetOps;
}

namespace NAntiPorno {

    class TAntiPorno {
    public:
        TAntiPorno(
            const TString& nnConfig,
            const TString& nnModel,
            ui64 workers);

        virtual ~TAntiPorno();

        TMap<TString, float> DetectPorno(const TCvMatImgPreparer& image) const;

    private:
        THolder<NNeuralNet::TDanetOps> DanetOps;
    };

    THolder<TCvMatImgPreparer> LoadImage(const void* data, size_t size);

    TString SerializePredictions(const TMap<TString, float>& predictions);
}

extern "C" {
    int JniWrapperCreateAntiPorno(const char* config, void** out) noexcept;

    void JniWrapperDestroyAntiPorno(void* instance) noexcept;

    int JniWrapperDetectPorno(
        void* instance,
        const char* text,
        const char* metainfo,
        const void* data,
        size_t size,
        char** out) noexcept;
}

