#pragma once

#include "curl.h"

typedef void CURLM;
class TCont;

namespace NCurl {
    using TCurlArtPair = std::pair<std::reference_wrapper<TCurl>, std::reference_wrapper<TArtifacts>>;

    class TMultiCurl : private TCurlBase {
        class TLock {
        public:
            TLock(const TLock&) = delete;
            TLock(TLock&& other) noexcept = default;
            TLock(CURL* easy, CURLM* multi);
            ~TLock();
        private:
            THolder<CURL, TNoAction> easy;
            THolder<CURLM, TNoAction> multi;
        };

    public:
        TMultiCurl();
        TMultiCurl(TMultiCurl&& other) noexcept = default;
        TMultiCurl(const TMultiCurl &) = delete;

        [[nodiscard]] TVector<TMaybe<TError>> Perform(const TInstant& deadline, const TVector<TCurlArtPair>& curlsArts, TCont* cont = nullptr);

    private:
        int Select(const TDuration& timeout, TCont* cont);
        int SimpleSelect(const TDuration& timeout);
        int CoroSelect(const TDuration& timeout, TCont* cont);

        struct TDestroyer { static void Destroy(CURLM * c); };
        THolder<CURLM, TDestroyer> context;
    };

    using TMultiPool = ::TPool<TMultiCurl>;
    using TMultiPoolItemHolder = TMultiPool::TItemHolder;

    class TMultiPoolTraits : public TMultiPool::TPoolItemTraits {
    public:
        THolder<TMultiCurl> create() const override;
    };

}   //  namespace NCurl
