#include <library/cpp/testing/unittest/registar.h>
#include <util/string/strip.h>

#include "curl.h"
#include "server.h"

Y_UNIT_TEST_SUITE(CURL) {
    Y_UNIT_TEST(Main) {
        THandlerServer server;

        NCurl::TOptions options;
        options.SetMaxAliveConnections(3);
        options.SetParseHeaders(true);
        options.SetParseBody(true);

        NCurl::TRequestContext request;
        request.SetHost("127.0.0.1");
        request.SetPort(ut_port);
        request.SetRequestTimeout(TDuration::Seconds(5));
        request.SetConnectTimeout(TDuration::Seconds(1));
        request.SetPostData("testing message");
        request.SetContentType("text/html");
        TVector<TString> headers(1, "Header: test");
        request.AddHeaders(headers);

        NCurl::TCurl curl(options);
        NCurl::TSimpleArtifacts artifact;

        if(auto error = curl.Setup(std::move(request)).Perform(artifact)) {
            ythrow yexception() << *error;
        }

        auto result = server.GetHeaders();
        UNIT_ASSERT_EQUAL(result["Header"], "test");
        UNIT_ASSERT_EQUAL(result["Content-Type"], "text/html");

        UNIT_ASSERT_EQUAL(server.GetBody(), "testing message");

        UNIT_ASSERT_EQUAL(StripInPlace(artifact.firstLine), "HTTP/1.1 200 Ok");
        UNIT_ASSERT_EQUAL(artifact.body.Str(), "testing message");
    }
};
