#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/xrange.h>

#include "multi.h"
#include "server.h"

Y_UNIT_TEST_SUITE(Multi) {
    Y_UNIT_TEST(Main) {
        THandlerServer server;

        const size_t count = 13;
        TVector<NCurl::TCurl> curls;
        for (size_t i = 0; i < count; ++i) {
            curls.emplace_back().Setup(std::move(NCurl::TRequestContext()
                                                         .SetHost("127.0.0.1")
                                                         .SetPort(ut_port)
                                                         .SetContentType("text/html")
                                                         .SetPostData("message #" + ToString(i))));
        }

        NCurl::TMultiCurl multi;
        TVector<NCurl::TSimpleArtifacts> artifacts(count);

        TVector<NCurl::TCurlArtPair> pairs(Reserve(count));
        for(size_t i : xrange(count)) {
            pairs.emplace_back(curls[i], artifacts[i]);
        }

        if(auto errors = multi.Perform(TDuration::Max().ToDeadLine(), pairs)) {
            for(const auto& error : errors) {
                if(error) {
                    ythrow yexception() << *error;
                }
            }
        }

        for (size_t i = 0; i < count; ++i) {
            UNIT_ASSERT_EQUAL(artifacts[i].body.Str(), "message #" + ToString(i));
        }
    }
};
