#include <library/cpp/http/server/response.h>
#include "server.h"

THandlerServer::TRequest::TRequest(THandlerServer* server) : server(server) {
    Y_ASSERT(server != nullptr);
}

bool THandlerServer::TRequest::Reply(void*) {
    if (!Prepare())
        return true;

    for (const auto& item : ParsedHeaders)
        server->SetHeader(item.first, item.second);

    TString body(static_cast<const char*>(Buf.Data()), Buf.Length());
    server->SetBody(body);

    THttpResponse(HTTP_OK).OutTo(Output());
    Output() << body;
    return true;
}

bool THandlerServer::TRequest::Prepare() {
    if (!ProcessHeaders()) {
        return false;
    }
    RD.Scan();
    return true;
}

THandlerServer::THandlerServer() : THttpServer(this, THttpServerOptions(ut_port)) {
    Start();
}

THandlerServer::~THandlerServer() {
    Shutdown();
    Wait();
}

void THandlerServer::SetBody(const TString& data) {
    with_lock(mutex) {
        body = data;
    }
}

TString THandlerServer::GetBody() const {
    with_lock(mutex) {
        return body;
    }
}

void THandlerServer::SetHeader(const TString& key, const TString value) {
    with_lock(mutex) {
        headers[key] = value;
    }
}

THashMap<TString, TString> THandlerServer::GetHeaders() const {
    with_lock(mutex) {
        return headers;
    }
}

TClientRequest* THandlerServer::CreateClient() {
    return MakeHolder<TRequest>(this).Release();
}
