#include "wrapper.h"

#include <mail/so/libs/jniwrapper_base/jniwrapper_base.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TestAntiPorno) {
    Y_UNIT_TEST(JniWrapperTest) {
        const char* config =
            "<Deobfuscator>\n"
                "RemapPath: rus.dict/deobfuscator/remap.json\n"
                "TriePath: rus.dict/deobfuscator/dict.trie\n"
            "</Deobfuscator>\n"
            "<Deobfuscator>\n"
                "RemapPath: en.dict/deobfuscator/remap.json\n"
                "TriePath: en.dict/deobfuscator/dict.trie\n"
            "</Deobfuscator>\n";
        void *instance;
        UNIT_ASSERT_C(
            JniWrapperCreateDeobfuscator(config, &instance) == 0,
            (const char*) instance);
        char* out;
        UNIT_ASSERT_C(
            JniWrapperDeobfuscateText(instance, "∏рuвет, П0ДAPOK, П0К0КККААСВВА, посмоmpeла 0ХУGЕNS", nullptr, nullptr, 0, &out) == 0,
            out);
        UNIT_ASSERT_STRINGS_EQUAL("привет подарок п0к0кккаасвва посмотрела oxygens", out);
        JniWrapperFree(out);
        JniWrapperDestroyDeobfuscator(instance);
    }
}
