#pragma once

#include <library/cpp/yconf/conf.h>

#include <cstddef>

namespace NTextDeobfuscate {
    class TTextDeobfuscator;
}

namespace NDeobfuscatorWrapper {
    DEFINE_SECTION(Deobfuscator)
        DIRECTIVE(RemapPath)
        DIRECTIVE(TriePath)
    END_DEFINE_SECTION

    DECLARE_CONFIG(TDeobfuscatorConfig)

    NTextDeobfuscate::TTextDeobfuscator* CreateDeobfuscator(TYandexConfig& config);
}

extern "C" {
    int JniWrapperCreateDeobfuscator(const char* config, void** out) noexcept;

    void JniWrapperDestroyDeobfuscator(void* instance) noexcept;

    int JniWrapperDeobfuscateText(
        void* instance,
        const char* text,
        const char* metainfo,
        const void* data,
        size_t size,
        char** out) noexcept;
}

