#pragma once

#include <geobase/include/lookup.hpp>

#include <util/generic/string.h>

namespace NGeobaseLookup {
    TString GetIpInfoFromGeobase(
        const NGeobase::NImpl::TLookup* lookup,
        const std::string& ip);
}

extern "C" {
    int JniWrapperCreateGeobaseLookup(const char* config, void** out) noexcept;

    void JniWrapperDestroyGeobaseLookup(void* instance) noexcept;

    int JniWrapperGetIpInfoFromGeobase(
        void* instance,
        const char* ip,
        const char* metainfo,
        void* data,
        size_t size,
        char** out) noexcept;
}

