#include <mail/so/libs/geobase_lookup/geobase_lookup.h>

#include <mail/so/libs/jniwrapper_base/jniwrapper_base.h>

#include <geobase/include/lookup.hpp>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <util/memory/blob.h>
#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/json/json_reader.h>

static NJson::TJsonValue LoadCanonical(const char* ip) {
    TBlob canonicalData = TBlob::FromFile(TString::Join(SRC_("canonical_data/") + '/', ip, ".json"));
    return NJson::ReadJsonFastTree({canonicalData.AsCharPtr(), canonicalData.Length()});
}

static void TestIp(const char* ip) {
    auto lookup = MakeHolder<NGeobase::NImpl::TLookup>("geodata6.bin");
    UNIT_ASSERT_VALUES_EQUAL(
        LoadCanonical(ip),
        NJson::ReadJsonFastTree(NGeobaseLookup::GetIpInfoFromGeobase(lookup.Get(), ip)));
}

Y_UNIT_TEST_SUITE(TestGeobaseLookup) {
    Y_UNIT_TEST(TorNodeTest) {
        TestIp("95.128.43.164");
    }
    Y_UNIT_TEST(YandexIpTest) {
        TestIp("95.108.131.197");
    }
    Y_UNIT_TEST(UnknownIpTest) {
        TestIp("192.168.2.4");
    }
    Y_UNIT_TEST(UralIpTest) {
        TestIp("176.59.207.32");
    }
    Y_UNIT_TEST(GmailIPv6Test) {
        void* instance;
        JniWrapperCreateGeobaseLookup("geodata6.bin", &instance);
        char* out;
        int ret = JniWrapperGetIpInfoFromGeobase(
            instance,
            "2001:4860:0:1::531",
            nullptr,
            nullptr,
            0,
            &out);
        TString result{static_cast<const char*>(out)};
        JniWrapperFree(out);
        JniWrapperDestroyGeobaseLookup(instance);
        UNIT_ASSERT_VALUES_EQUAL_C(0, ret, result);
        UNIT_ASSERT_VALUES_EQUAL(LoadCanonical("2001.4860.0.1..531"), NJson::ReadJsonFastTree(result));
    }
}

