#include <mail/so/spamstop/tools/text2shingles/lib/text2shingles.h>
#include <mail/so/libs/html_sanitizer_misc/html_sanitizer_misc.h>

#include <library/cpp/json/json_reader.h>

#include <util/memory/blob.h>
#include <util/stream/output.h>
#include <util/string/join.h>

int main(int, char* argv[]) {
    TBlob blob{TBlob::FromFile(argv[1])};
    TString str{(char*) blob.Data(), blob.Length()};
    NJson::TJsonValue json;
    NJson::ReadJsonTree(str, &json, true);
    NHtmlSanMisc::TAnswer answer{NHtmlSanMisc::TAnswer::Parse(std::move(json))};
    Cout << "Body:" << Endl;
    Cout << answer.FindVisiblePart()->PureBody.Clipped << Endl;
    Cout << "Body shingles:" << Endl;
    Cout << JoinSeq(",", NText2Shingles::Text2Shingles(answer.FindVisiblePart()->PureBody.Clipped, LANG_UNK, true, std::numeric_limits<size_t>::max())) << Endl;
    Cout << "Subject:" << Endl;
    Cout << answer.FindVisiblePart()->Subject.Clipped << Endl;
}

