package ru.yandex.data.compressor;

public class CompressorException extends Exception {
    private static final long serialVersionUID = 0L;
    private static final String USING = " using ";
    private static final String FAILED_BESAUSE_OF = " failed because of next cause: ";
    private static final String STATUS = ". Status of operation: ";

    public CompressorException(String message) {
        super(message);
    }

    public CompressorException(String message, Exception cause) {
        super(message, cause);
    }

    public CompressorException(CompressorActionContext actionContext) {
        super(actionContext.type().name().substring(0, 1).toUpperCase() + actionContext.type().name().substring(1)
            + USING + actionContext.info() + FAILED_BESAUSE_OF  + actionContext.status());
    }

    public CompressorException(CompressorActionContext actionContext, final Exception e) {
        super(actionContext.type().name().substring(0, 1).toUpperCase() + actionContext.type().name().substring(1)
            + USING + actionContext.info() + FAILED_BESAUSE_OF  + actionContext.status(), e);
    }

    public CompressorException(CompressorActionContext actionContext, final String message) {
        super(actionContext.type().name().substring(0, 1).toUpperCase() + actionContext.type().name().substring(1)
            + USING + actionContext.info() + FAILED_BESAUSE_OF  + message + STATUS + actionContext.status());
    }

    public CompressorException(CompressorActionContext actionContext, final String message, final Exception e) {
        super(actionContext.type().name().substring(0, 1).toUpperCase() + actionContext.type().name().substring(1)
            + USING + actionContext.info() + FAILED_BESAUSE_OF  + message + STATUS + actionContext.status(), e);
    }
}
