package ru.yandex.data.compressor;

import ru.yandex.base64.Base64;

public enum DataCompressor implements Compressor {
    RAW {
        @Override
        public byte[] compress(final byte[] data) {
            if (data == null || data.length < 1) {
                return new byte[]{};
            }
            return data;
        }

        @Override
        public byte[] uncompress(final byte[] data) {
            if (data == null || data.length < 1) {
                return new byte[]{};
            }
            return data;
        }
    },
    LZO {
        public static final int UNCOMPRESS_SUSPICIOUS_SIZE = 5242880;

        @Override
        public byte[] compress(final byte[] data) throws CompressorException {
            if (data == null || data.length < 1) {
                return new byte[]{};
            }
            LzoActionContext context = new LzoActionContext(CompressorActionType.COMPRESSING);
            try {
                return context.compress(data);
            } catch (CompressorException e) {
                e.printStackTrace();
                throw new CompressorException(context, "compress failed: " + e.getMessage(), e);
            }
        }

        @Override
        public byte[] uncompress(final byte[] data) throws CompressorException {
            if (data == null || data.length < 1) {
                return new byte[]{};
            }
            LzoActionContext context = new LzoActionContext(CompressorActionType.DECOMPRESSING);
            try {
                return context.uncompress(data);
            } catch (RuntimeException e) {
                e.printStackTrace();
                throw new CompressorException(context, "uncompress failed: " + e.getMessage(), e);
            }
        }

        @Override
        public String unbase64AndUncompress(final String data, final Base64 base64type) throws CompressorException
        {
            LzoActionContext context = new LzoActionContext(CompressorActionType.DECOMPRESSING);
            if (data.length() >= UNCOMPRESS_SUSPICIOUS_SIZE) {
                throw new CompressorException(context, "Buffer too big > UNCOMPRESS_SUSPICIOUS_SIZE");
            }
            final String result = super.unbase64AndUncompress(data, base64type);
            if (result != null && result.length() >= UNCOMPRESS_SUSPICIOUS_SIZE) {
                throw new CompressorException(context, "Buffer too big > UNCOMPRESS_SUSPICIOUS_SIZE");
            }
            return result;
        }
    }
}
