package ru.yandex.data.compressor;

public class LzoActionContext implements CompressorActionContext {
    private final CompressorActionType actionType;
    private final LzoAlgorithm algorithm;
    private final LzoConstraint constraint;
    private String status = "OK";

    public LzoActionContext(
        final CompressorActionType actionType,
        final LzoAlgorithm algorithm,
        final LzoConstraint constraint)
    {
        this.actionType = actionType;
        this.algorithm = algorithm;
        this.constraint = constraint;
    }

    public LzoActionContext(final CompressorActionType actionType) {
        this(actionType, LzoAlgorithm.LZO1X, actionType == CompressorActionType.COMPRESSING
            ? LzoConstraint.COMPRESSION_BEST : LzoConstraint.UNCOMRESSION_SAFE);
    }

    @Override
    public CompressorActionType type() {
        return actionType;
    }

    @Override
    public String status() {
        return status;
    }

    @Override
    public String info() {
        return algorithm + "/" + constraint;
    }

    public LzoAlgorithm algorithm() {
        return algorithm;
    }

    public LzoConstraint constraint() {
        return constraint;
    }

    public byte[] compress(final byte[] data) throws CompressorException {
        return LzoLibrary.compress(data, algorithm, constraint);
    }

    public byte[] uncompress(final byte[] data) throws CompressorException {
        return LzoLibrary.uncompress(data, algorithm, constraint);
    }
}
